<?php
/**
 * Plugin Name: Performance Insights - Plugin Exclusion Analyzer
 * Description: Analyze Lighthouse JSON reports to identify problematic scripts, map them to plugin sources, and get exclusion suggestions for better performance optimization.
 * Version: 1.0.0
 * Author: Your Name
 * License: GPLv2 or later
 * Text Domain: performance-insights
 */

if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
if (!defined('PI_PLUGIN_FILE')) {
    define('PI_PLUGIN_FILE', __FILE__);
}
if (!defined('PI_PLUGIN_DIR')) {
    define('PI_PLUGIN_DIR', plugin_dir_path(__FILE__));
}
if (!defined('PI_PLUGIN_URL')) {
    define('PI_PLUGIN_URL', plugin_dir_url(__FILE__));
}

// Activation/Deactivation hooks
function pi_activate() {
    // Placeholder for future: create custom tables/options if needed
}
register_activation_hook(__FILE__, 'pi_activate');

function pi_deactivate() {
    // Placeholder for future cleanup
}
register_deactivation_hook(__FILE__, 'pi_deactivate');

// Includes
require_once PI_PLUGIN_DIR . 'includes/class-pi-parser.php';
require_once PI_PLUGIN_DIR . 'includes/class-pi-insights.php';
require_once PI_PLUGIN_DIR . 'admin/class-pi-admin.php';

// Bootstrap
add_action('plugins_loaded', function () {
    load_plugin_textdomain('performance-insights', false, dirname(plugin_basename(__FILE__)) . '/languages/');
});

// Initialize admin class
if (is_admin()) {
    new PI_Admin();
}
