<?php if (!defined('ABSPATH')) { exit; } ?>

<div class="wrap">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    <p class="description"><?php _e('Analyze Lighthouse reports to identify problematic scripts and get plugin exclusion suggestions for better performance.', 'performance-insights'); ?></p>
    
    <?php if (!empty($results['errors']) && empty($results['sections'])): ?>
        <div class="notice notice-error">
            <?php foreach ($results['errors'] as $error): ?>
                <p><?php echo esc_html($error); ?></p>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
    
    <?php if (empty($results) || (empty($results['sections']) && !empty($results['errors']))): ?>
        <div class="pi-instructions">
            <h2><?php _e('How to Generate Lighthouse Report', 'performance-insights'); ?></h2>
            <ol>
                <li><?php _e('Open your site in Google Chrome.', 'performance-insights'); ?></li>
                <li><?php _e('Press F12 (or right-click → Inspect) to open DevTools.', 'performance-insights'); ?></li>
                <li><?php _e('Go to the Lighthouse tab.', 'performance-insights'); ?></li>
                <li><?php _e('Select Performance (and optionally other categories).', 'performance-insights'); ?></li>
                <li><?php _e('Click "Analyze page load".', 'performance-insights'); ?></li>
                <li><?php _e('After the report generates, click the Export icon → choose "Download JSON".', 'performance-insights'); ?></li>
                <li><?php _e('Open the JSON file in any text editor, copy everything, and paste it into the box below.', 'performance-insights'); ?></li>
            </ol>
        </div>
        
        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" class="pi-form">
            <input type="hidden" name="action" value="pi_analyze">
            <?php wp_nonce_field('pi_analyze', 'pi_nonce'); ?>
            
            <table class="form-table">
                <tr>
                    <th scope="row">
                        <label for="lighthouse_json"><?php _e('Lighthouse JSON Report', 'performance-insights'); ?></label>
                    </th>
                    <td>
                        <textarea 
                            id="lighthouse_json" 
                            name="lighthouse_json" 
                            rows="15" 
                            cols="80" 
                            class="large-text code"
                            placeholder="<?php esc_attr_e('Paste your Lighthouse JSON report here...', 'performance-insights'); ?>"
                        ><?php echo isset($_POST['lighthouse_json']) ? esc_textarea($_POST['lighthouse_json']) : ''; ?></textarea>
                        <p class="description">
                            <?php _e('Paste the complete JSON content from your Lighthouse export.', 'performance-insights'); ?>
                        </p>
                    </td>
                </tr>
            </table>
            
            <?php submit_button(__('Analyze for Plugin Insights', 'performance-insights'), 'primary', 'submit', false); ?>
        </form>
    <?php endif; ?>
    
    <?php if (!empty($results) && !empty($results['sections'])): ?>
        <?php if (!empty($results['warnings'])): ?>
            <div class="notice notice-warning">
                <?php foreach ($results['warnings'] as $warning): ?>
                    <p><?php echo esc_html($warning); ?></p>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
        
        <div class="pi-results">
            
            <?php if (!empty($results['summary'])): ?>
                <div class="pi-summary-box">
                    <h2><?php _e('Performance Insights Summary', 'performance-insights'); ?></h2>
                    <div class="pi-summary-stats">
                        <div class="pi-stat">
                            <span class="pi-stat-number"><?php echo esc_html($results['summary']['total_scripts']); ?></span>
                            <span class="pi-stat-label"><?php _e('Problematic Scripts', 'performance-insights'); ?></span>
                        </div>
                        <div class="pi-stat">
                            <span class="pi-stat-number"><?php echo count($results['summary']['plugin_breakdown']); ?></span>
                            <span class="pi-stat-label"><?php _e('Plugins/Sources', 'performance-insights'); ?></span>
                        </div>
                    </div>
                    
                    <?php if (!empty($results['summary']['recommendations'])): ?>
                        <div class="pi-recommendations">
                            <h3><?php _e('Top Recommendations', 'performance-insights'); ?></h3>
                            <ul>
                                <?php foreach ($results['summary']['recommendations'] as $rec): ?>
                                    <li><?php echo esc_html($rec); ?></li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            
            <?php if (!empty($results['sections']['info'])): ?>
                <div class="pi-info-section">
                    <h2><?php echo esc_html($results['sections']['info']['title']); ?></h2>
                    <p><?php echo esc_html($results['sections']['info']['message']); ?></p>
                    
                    <table class="form-table">
                        <tr>
                            <th scope="row"><?php _e('Analyzed URL:', 'performance-insights'); ?></th>
                            <td><?php echo esc_html($results['sections']['info']['details']['url']); ?></td>
                        </tr>
                        <tr>
                            <th scope="row"><?php _e('Lighthouse Version:', 'performance-insights'); ?></th>
                            <td><?php echo esc_html($results['sections']['info']['details']['lighthouse_version']); ?></td>
                        </tr>
                        <tr>
                            <th scope="row"><?php _e('Fetch Time:', 'performance-insights'); ?></th>
                            <td><?php echo esc_html($results['sections']['info']['details']['fetch_time']); ?></td>
                        </tr>
                        <tr>
                            <th scope="row"><?php _e('Audits Available:', 'performance-insights'); ?></th>
                            <td><?php echo esc_html($results['sections']['info']['details']['audit_count']); ?></td>
                        </tr>
                    </table>
                </div>
            <?php endif; ?>
            
            <?php if (!empty($results['sections']['scripts']['scripts'])): ?>
                <div class="pi-scripts-section">
                    <h2><?php _e('Detailed Script Analysis', 'performance-insights'); ?></h2>
                    <p class="description"><?php echo esc_html($results['sections']['scripts']['summary']); ?></p>
                    
                    <div class="pi-table-controls">
                        <label for="pi-filter-source"><?php _e('Filter by source:', 'performance-insights'); ?></label>
                        <select id="pi-filter-source">
                            <option value=""><?php _e('All sources', 'performance-insights'); ?></option>
                            <option value="plugin"><?php _e('Plugins only', 'performance-insights'); ?></option>
                            <option value="theme"><?php _e('Theme only', 'performance-insights'); ?></option>
                            <option value="external"><?php _e('External only', 'performance-insights'); ?></option>
                        </select>
                        
                        <label for="pi-filter-severity"><?php _e('Filter by severity:', 'performance-insights'); ?></label>
                        <select id="pi-filter-severity">
                            <option value=""><?php _e('All severities', 'performance-insights'); ?></option>
                            <option value="critical"><?php _e('Critical only', 'performance-insights'); ?></option>
                            <option value="moderate"><?php _e('Moderate only', 'performance-insights'); ?></option>
                        </select>
                    </div>
                    
                    <table class="wp-list-table widefat fixed striped pi-scripts-table" id="pi-scripts-table">
                        <thead>
                            <tr>
                                <th class="pi-sortable" data-sort="url"><?php _e('Script/Resource', 'performance-insights'); ?></th>
                                <th class="pi-sortable" data-sort="source"><?php _e('Plugin/Source', 'performance-insights'); ?></th>
                                <th class="pi-sortable" data-sort="issue"><?php _e('Issue Type', 'performance-insights'); ?></th>
                                <th class="pi-sortable" data-sort="impact"><?php _e('Impact', 'performance-insights'); ?></th>
                                <th><?php _e('Exclusion Suggestion', 'performance-insights'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            // Sort scripts by priority
                            $scripts = $results['sections']['scripts']['scripts'];
                            usort($scripts, function($a, $b) {
                                return PI_Insights::get_priority_score($b) - PI_Insights::get_priority_score($a);
                            });
                            
                            foreach ($scripts as $script): 
                                $suggestion = PI_Insights::get_exclusion_suggestion($script);
                            ?>
                                <tr class="pi-severity-<?php echo esc_attr($script['severity']); ?>" 
                                    data-source-type="<?php echo esc_attr($script['source_type']); ?>"
                                    data-severity="<?php echo esc_attr($script['severity']); ?>">
                                    <td class="pi-script-url">
                                        <code title="<?php echo esc_attr($script['url']); ?>">
                                            <?php echo esc_html(basename(parse_url($script['url'], PHP_URL_PATH)) ?: $script['url']); ?>
                                        </code>
                                        <?php if ($script['source_type'] === 'plugin' && isset($script['plugin_info']['active']) && !$script['plugin_info']['active']): ?>
                                            <span class="pi-inactive-badge"><?php _e('Inactive', 'performance-insights'); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="pi-source">
                                        <span class="pi-source-type pi-source-<?php echo esc_attr($script['source_type']); ?>">
                                            <?php echo esc_html($script['source_name']); ?>
                                        </span>
                                        <?php if ($script['source_type'] === 'plugin' && !empty($script['plugin_info']['version'])): ?>
                                            <small class="pi-version">v<?php echo esc_html($script['plugin_info']['version']); ?></small>
                                        <?php endif; ?>
                                    </td>
                                    <td class="pi-issue-type">
                                        <span class="pi-issue-badge pi-issue-<?php echo esc_attr($script['issue_type']); ?>">
                                            <?php 
                                            $issue_labels = [
                                                'render-blocking' => __('Render Blocking', 'performance-insights'),
                                                'unused-js' => __('Unused JS', 'performance-insights'),
                                                'large-payload' => __('Large Payload', 'performance-insights'),
                                                'bootup-heavy' => __('Bootup Heavy', 'performance-insights')
                                            ];
                                            echo esc_html($issue_labels[$script['issue_type']] ?? $script['issue_type']);
                                            ?>
                                        </span>
                                    </td>
                                    <td class="pi-impact">
                                        <?php if ($script['impact_bytes'] > 0): ?>
                                            <span class="pi-impact-bytes"><?php echo esc_html(PI_Parser::format_bytes($script['impact_bytes'])); ?></span>
                                        <?php endif; ?>
                                        <?php if ($script['impact_ms'] > 0): ?>
                                            <span class="pi-impact-ms"><?php echo esc_html(PI_Parser::format_ms($script['impact_ms'])); ?></span>
                                        <?php endif; ?>
                                        <?php if (!empty($script['waste_percent'])): ?>
                                            <span class="pi-waste-percent">(<?php echo esc_html($script['waste_percent']); ?>%)</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="pi-suggestion">
                                        <div class="pi-suggestion-text">
                                            <?php echo esc_html($suggestion); ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
            
            <div class="pi-actions">
                <a href="<?php echo esc_url(admin_url('tools.php?page=pi-insights')); ?>" class="button">
                    <?php _e('Analyze Another Report', 'performance-insights'); ?>
                </a>
                <button type="button" class="button button-secondary" id="pi-export-csv">
                    <?php _e('Export as CSV', 'performance-insights'); ?>
                </button>
            </div>
        </div>
    <?php endif; ?>
</div>
