# Performance Insights - Plugin Exclusion Analyzer

A WordPress plugin that analyzes Lighthouse JSON reports to identify problematic scripts, maps them to their plugin sources, and provides actionable exclusion suggestions for better performance optimization.

## Features

- **Plugin Source Mapping**: Automatically identifies which plugins, themes, or external services are causing performance issues
- **Smart Exclusion Suggestions**: Get specific recommendations on where to exclude plugins (page types, categories, tags)
- **Comprehensive Analysis**: Analyzes 4 key performance areas:
  - Render-blocking resources
  - Unused JavaScript
  - Large payload sizes  
  - Boot-up heavy scripts (long tasks)
- **Enhanced Results Display**: 
  - Sortable table by impact, source, or issue type
  - Filter by plugin/theme/external sources
  - Filter by severity (critical/moderate/fine)
  - Color-coded severity indicators
- **Export Functionality**: Export results as CSV for external analysis
- **WordPress Native**: Integrates seamlessly with WordPress admin under Tools → Performance Insights

## Installation

1. Upload the `website-performance-analyzer` folder to your `/wp-content/plugins/` directory
2. Activate the plugin through the 'Plugins' menu in WordPress
3. Navigate to **Tools → Performance Insights** in your WordPress admin

## Usage

### Step 1: Generate Lighthouse Report
1. Open your website in Google Chrome
2. Press F12 (or right-click → Inspect) to open DevTools
3. Go to the **Lighthouse** tab
4. Select **Performance** (and optionally other categories)
5. Click **"Analyze page load"**
6. After the report generates, click the **Export icon** → choose **"Download JSON"**

### Step 2: Analyze in WordPress
1. Go to **Tools → Performance Insights** in your WordPress admin
2. Open the downloaded JSON file in any text editor
3. Copy the entire JSON content
4. Paste it into the textarea in the plugin
5. Click **"Analyze for Plugin Insights"**

### Step 3: Review Results & Exclusion Suggestions
The plugin displays an enhanced analysis with:

#### Summary Dashboard
- Total problematic scripts found
- Number of plugins/sources involved
- Top 3 recommendations for maximum impact

#### Detailed Script Analysis Table
- **Script/Resource**: The problematic file (click to copy full URL)
- **Plugin/Source**: Which plugin, theme, or external service owns it
- **Issue Type**: Render-blocking, Unused JS, Large Payload, or Bootup Heavy
- **Impact**: Potential savings in KB/MB and milliseconds
- **Exclusion Suggestion**: Specific recommendations on where to exclude

#### Smart Exclusion Suggestions
The plugin provides context-aware suggestions like:
- **Contact Form 7**: "Exclude on: category/tag archives, author pages | Keep on: pages with contact forms"
- **Elementor**: "Exclude on: category/tag archives, posts not built with Elementor | Keep on: pages built with Elementor"
- **WooCommerce**: "Exclude on: blog posts, non-shop pages | Keep on: shop, product, cart, checkout pages"

### Step 4: Apply Exclusions
Use the suggestions to configure your script optimization plugin (like WP Rocket, Autoptimize, or a dedicated script manager) to exclude specific plugins on the recommended page types.

## File Structure

```
website-performance-analyzer/
├── website-performance-analyzer.php  # Main plugin file
├── admin/
│   └── class-wpa-admin.php          # Admin interface handler
├── assets/
│   ├── admin.css                    # Admin styling
│   └── admin.js                     # Admin JavaScript
├── includes/
│   └── class-wpa-parser.php         # Lighthouse JSON parser
├── templates/
│   └── admin-page.php               # Admin page template
└── README.md                        # This file
```

## Technical Details

### Severity Levels
- **Critical**: 
  - Time-based: ≥500ms potential savings
  - Size-based: ≥200KB wasted bytes
- **Moderate**: 
  - Time-based: ≥150ms potential savings
  - Size-based: ≥50KB wasted bytes
- **Fine**: Below moderate thresholds

### Parsed Lighthouse Audits
- `render-blocking-resources`
- `unused-javascript`
- `unused-css-rules`
- `total-byte-weight`
- `bootup-time`

## Future Enhancements

- **History Tracking**: Save multiple analyses for comparison
- **Before/After Comparison**: Compare performance improvements
- **CSV Export**: Export results for external analysis
- **Quick Fix Tips**: Provide actionable optimization suggestions
- **Google PSI API Integration**: Automate report generation
- **Scheduled Analysis**: Automatic periodic performance checks

## Requirements

- WordPress 5.0 or higher
- PHP 7.4 or higher
- `manage_options` capability for admin access

## Security

- Nonce verification for form submissions
- Capability checks for admin access
- Sanitized input handling
- Transient storage for temporary results

## Support

For issues, feature requests, or contributions, please contact the plugin author or submit through your preferred support channel.

## License

GPLv2 or later
