<?php
/**
 * Freemium control and status class
 */

if (!defined('ABSPATH')) {
    exit;
}

class PAGESPSC_Freemium {
    // Free tier limits
    const FREE_MAX_CONDITIONS = 2;
    const FREE_MAX_PLUGINS_PER_CONDITION = 50; // soft cap for UI, not enforced strictly unless needed

    /**
     * Count total conditions.
     */
    public static function count_conditions() {
        global $wpdb;
        
        $cache_key = 'pagespsc_conditions_count';
        $count = wp_cache_get($cache_key);
        
        if (false === $count) {
            $table = $wpdb->prefix . 'pagespsc_conditions';
            // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery -- Checking if custom table exists
            if ($wpdb->get_var($wpdb->prepare("SHOW TABLES LIKE %s", $table)) !== $table) {
                return 0;
            }
            // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery -- Custom table requires direct query for count
            $count = $wpdb->get_var("SELECT COUNT(*) FROM `{$wpdb->prefix}pagespsc_conditions`");
            wp_cache_set($cache_key, $count, '', 300); // Cache for 5 minutes
        }
        
        return $count;
    }

    /**
     * Remaining slots for free plan.
     */
    public static function get_remaining_conditions() {
        // Always use free limits in Lite version
        $used = self::count_conditions();
        $remaining = max(0, self::FREE_MAX_CONDITIONS - $used);
        return $remaining;
    }

    /**
     * REST: GET /pagespsc/v1/status
     */
    public function get_status_api() {
        // Always false in Lite version
        $is_premium = false;
        $status = array(
            'is_premium' => $is_premium,
            'limits' => array(
                'max_conditions' => self::FREE_MAX_CONDITIONS,
                'max_plugins_per_condition' => self::FREE_MAX_PLUGINS_PER_CONDITION,
                'pages_only' => true,
            ),
            'remaining' => self::get_remaining_conditions(),
            'upgrade_url' => function_exists('pagespsc_get_upgrade_url') ? pagespsc_get_upgrade_url() : '',
        );

        return rest_ensure_response($status);
    }
}
