<?php
/**
 * Admin interface class
 */

if (!defined('ABSPATH')) {
    exit;
}

class PAGESPSC_Admin {
    
    public function __construct() {
        // Constructor - admin menu is added via PAGESPSC_Core
    }
    
    public function add_admin_menu() {
        add_menu_page(
            __('Page Speed Script Optimizer', 'conditional-load-manager-lite'),
            __('Script Optimizer', 'conditional-load-manager-lite'),
            'manage_options',
            'page-speed-script-optimizer',
            array($this, 'render_admin_page'),
            'data:image/svg+xml;base64,' . base64_encode('<svg width="20" height="20" viewBox="0 0 100 100" xmlns="http://www.w3.org/2000/svg"><circle cx="50" cy="50" r="45" fill="#2271b1" stroke="#fff" stroke-width="4"/><rect x="25" y="20" width="8" height="15" rx="2" fill="#fff"/><rect x="35" y="20" width="8" height="15" rx="2" fill="#fff"/><rect x="20" y="35" width="25" height="8" rx="4" fill="#fff"/><rect x="20" y="45" width="15" height="25" rx="7" fill="#fff"/><path d="M55 25 L75 35 L70 40 L55 35 Z" fill="#fff"/><circle cx="65" cy="45" r="3" fill="#fff"/><path d="M50 15 Q85 15 85 50 Q85 85 50 85" stroke="#00d084" stroke-width="4" fill="none"/></svg>'),
            65
        );

        // Only show upgrade page if Pro plugin is not active
        if (!defined('PAGESPSC_PRO_VERSION')) {
            add_submenu_page(
                'page-speed-script-optimizer',
                __('Upgrade to Pro', 'conditional-load-manager-lite'),
                __('Upgrade to Pro', 'conditional-load-manager-lite'),
                'manage_options',
                'page-speed-script-optimizer-upgrade',
                array($this, 'render_account_page')
            );
        }
    }
    
    public function render_admin_page() {
        ?>
        <div class="wrap">
            <h1>
                <img src="<?php echo esc_url(PAGESPSC_PLUGIN_URL . 'assets/plugin-icon.png'); ?>" 
                     alt="" 
                     style="width: 24px; height: 24px; margin-right: 8px; vertical-align: middle;" />
                <?php esc_html_e('Page Speed Script Optimizer', 'conditional-load-manager-lite'); ?>
                <span class="pagespsc-badge" style="background: #666; color: white; padding: 3px 8px; border-radius: 3px; font-size: 12px; margin-left: 8px; vertical-align: middle;">Lite</span>
            </h1>
            
            <div id="pagespsc-admin-root"></div>
        </div>
        <?php
    }

    public function render_account_page() {
        // Redirect to product purchase page
        $upgrade_url = 'https://wpcraftbench.com/product/plugin-load-manager/';
        
        // Enqueue inline script properly
        wp_add_inline_script('jquery', 'window.open("' . esc_url($upgrade_url) . '", "_blank");');
        ?>
        <div class="wrap">
            <h1>
                <img src="<?php echo esc_url(PAGESPSC_PLUGIN_URL . 'assets/plugin-icon.png'); ?>" 
                     alt="" 
                     style="width: 24px; height: 24px; margin-right: 8px; vertical-align: middle;" />
                <?php esc_html_e('Upgrade to Pro', 'conditional-load-manager-lite'); ?>
                <span class="pagespsc-badge" style="background: #666; color: white; padding: 3px 8px; border-radius: 3px; font-size: 12px; margin-left: 8px; vertical-align: middle;">Lite</span>
            </h1>
            
            <div class="pagespsc-upgrade-container" style="max-width:720px;">
                <div class="card">
                    <h2>🚀 Upgrade to Page Speed Script Optimizer Pro</h2>
                    <p>Get unlimited conditions, categories & tags targeting, and advanced performance optimizations.</p>
                    
                    <div class="pagespsc-compare" style="display:grid;grid-template-columns:1fr 1fr;gap:20px;margin:20px 0;">
                        <div>
                            <h3>Lite Version (Current)</h3>
                            <ul>
                                <li>✅ Up to 2 conditions</li>
                                <li>✅ Pages targeting</li>
                                <li>❌ No categories/tags targeting</li>
                                <li>❌ Limited performance optimization</li>
                            </ul>
                        </div>
                        <div>
                            <h3>Pro Version</h3>
                            <ul>
                                <li>🚀 Unlimited conditions</li>
                                <li>🚀 Pages targeting</li>
                                <li>🚀 Categories & tags targeting</li>
                                <li>🚀 Advanced performance optimization</li>
                                <li>🚀 Priority support</li>
                            </ul>
                        </div>
                    </div>
                    
                    <p>
                        <a href="<?php echo esc_url(pagespsc_get_upgrade_url()); ?>" class="button button-primary button-hero" target="_blank">
                            <?php esc_html_e('Get Pro Version', 'conditional-load-manager-lite'); ?>
                        </a>
                    </p>
                </div>
            </div>
        </div>
        <?php
    }

    // License page removed for WordPress.org compliance
}
